<?php
	include_once($_SERVER['DOCUMENT_ROOT'] . '/admin/inc/class.features.inc.php');
	$storeObj = new stores();
	$localPromos = $storeObj->getCurrentFeatures();
	$blacklist = $storeObj->getAllBlacklisted();
	
	$url = "http://afsshareportal.com/lookUpFeatures.php?action=getFeaturesCurl&website_url=" . urlencode(WEB_URL) . "&sg=" . urlencode(SITE_SG) . "&store_name=" . urlencode(STORE_NAME);
	
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_HEADER, false);
	$result=curl_exec($ch);
	
	$sharedPromos = json_decode($result, true);
	
	curl_close($ch);
	
	
	if(is_null($sharedPromos)){
		$sharedPromos = array();
	}
	
	if(count($blacklist) > 0){
		foreach($blacklist as $aPromo){
			$theID = $aPromo['featureID'];
			foreach($sharedPromos as $key => $sgPromo){
				if(in_array($theID, $sgPromo)){
					unset($sharedPromos[$key]);
					break;
				}
			}
		}
	}
	
	foreach($sharedPromos as &$sgPromo){
		//Allow local overrides if the file exists in the local directory
		$sgPromo['feature_photoHor'] = $sgPromo['feature_photoHor'];
		if(!is_file($_SERVER['DOCUMENT_ROOT'] . "/" . $sgPromo['feature_photoHor'])){
			$sgPromo['feature_photoHor'] = BASE_SITE . $sgPromo['feature_photoHor'];
		};
		
		$sgPromo['feature_photoVert'] = $sgPromo['feature_photoVert'];
		if(!is_file($_SERVER['DOCUMENT_ROOT'] . "/" . $sgPromo['feature_photoVert'])){
			$sgPromo['feature_photoVert'] = BASE_SITE . $sgPromo['feature_photoVert'];
		};
		
		$sgPromo['feature_photoSquare'] = $sgPromo['feature_photoSquare'];
		if(!is_file($_SERVER['DOCUMENT_ROOT'] . "/" . $sgPromo['feature_photoSquare'])){
			$sgPromo['feature_photoSquare'] = BASE_SITE . $sgPromo['feature_photoSquare'];
		};
		
	}
	
	$allPromos = array_merge($localPromos, $sharedPromos);
	
?>



<div class="carousel-buffer noMarginTop"><i class="icon-pause slideControl">&nbsp;</i><span id="slideControl">pause</span></div>
<div id="myCarousel" class="carousel slide">
  <!-- Carousel items -->
  <div class="carousel-inner">
	<?php
		$promoCnt = 0;
		foreach($allPromos as $aPromo){
			$specialClass = "";
			$isCommon = $aPromo['feature_common'];
			if($promoCnt == 0) $specialClass = "active";
			if($promoCnt > 5 && $isCommon == "1"){
				break;
			}
			
			$ignoreList = array('','none', 'apponly', 'app-only', 'webonly', 'web-only', 'webOnly');
			
			if(isset($aPromo['feature_link']) && $aPromo['feature_link'] != ""){
				$theLink = $aPromo['feature_link'];
				$linkIt = true;
			}else if(isset($aPromo['feature_file']) && !in_array($aPromo['feature_file'], $ignoreList)){
				$theLink = "/promotions/" . $aPromo['feature_file'];
				$linkIt = true;
			}else{
				$theLink = "#";
				$linkIt = false;
			}
			
			$theLink = $theLink . "?banner=true"
	?>
		<div class="item <?php echo $specialClass; ?>">
			<?php
				if($linkIt){
			?>
				<a href="<?php echo $theLink; ?>">
			<?php
				}
			?>
			<img src="<?php echo $aPromo['feature_photoHor']; ?>" alt="<?php echo stripslashes($aPromo['feature_headline']); ?>">
			<?php
				if($linkIt){
			?>
				</a>
			<?php
				}
			?>
			<div class="carousel-caption clearfix">
				<h4><?php echo stripslashes($aPromo['feature_headline']); ?></h4>
				<p><?php echo stripslashes($aPromo['feature_text']); ?></p>
				<?php
					if($linkIt){
				?>
					<p class="readMoreBtn"><a class="btn" href="<?php echo $theLink ?>">Read More</a></p>
				<?php
					}
				?>
			</div>
		</div>
	<?php
			$promoCnt++;
		}
	?>
  </div>
  <!-- Carousel nav -->
  <a class="carousel-control left" href="#myCarousel" data-slide="prev">&lsaquo;</a>
  <a class="carousel-control right" href="#myCarousel" data-slide="next">&rsaquo;</a>
</div>

<script>
  
  $(document).ready(function(){
	var myInterval = setInterval(function(){
		setCarouselHeight();
	},500);
	
	setTimeout(function(){
		clearInterval(myInterval);
	},3000);
	
	$("#myCarousel").carousel('cycle');
	
	$(window).resize(function(){
	  var win = $(this).width();
	  
	  if(win < 940){
		setCarouselHeight();
	  }
	});
	
	function setCarouselHeight(){
	  var picHeight = $("#myCarousel .carousel-inner .item.active img").height();
	  var captionHeight = $("#myCarousel .carousel-inner .item.active .carousel-caption").outerHeight();
	  //$("#myCarousel .carousel-inner").height(picHeight + captionHeight);
	}
  });
  
  
  
	$("#slideControl, .slideControl").bind("click", function(){
		//console.log($("#slideControl").text());
		if($("#slideControl").text() == "pause"){
			$("#slideControl").text("play");
			$("#slideControl").siblings("i").removeClass("icon-pause").addClass("icon-play");
			$("#myCarousel").carousel("pause");
		}else{
			$("#slideControl").text("pause");
			$("#slideControl").siblings("i").removeClass("icon-play").addClass("icon-pause");
			$("#myCarousel").carousel('cycle');
		}
    });
    
    
</script>
