<?php
  require('inc/sessionStart.php');
?>

<?php
  $pageTitle = "Administration: Store Details";
  $pageDescription = "";
  $pageKeywords = "";
?>

  
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php"); 
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php");
  
  $url = "https://afsshareportal.com/lookUpFeatures.php?action=storeInfoCurl&website_url=" . urlencode(WEB_URL);
	
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_HEADER, false);
  $result=curl_exec($ch);
  
  //var_dump(json_decode($result, true));
  
  //$result = substr($result, 1, (count($result) -2 ));
  
  $stores = json_decode($result, true);
  //var_dump($stores);
  curl_close($ch);
  
?>

    <section class="container">
      <div id="blankBuffer" class="carousel-buffer"></div>
      <div id="noEditError" class="hideObject">
			<div class="alert alert-error">
				  <a class="close" data-dismiss="alert" href="#">x</a>You can only <span id="noEditErrorText"></span> if you have editing capabilities.
			</div>
	  </div>
	  <section class="container" id="storePortal">
	    <div class="row">
		  <div class="span3 sideNav">
			<?php include('inc/sideNav.php'); ?>
		  </div>
		  
		  <div class="span9 portalContent">
			<div class="contentContain">
			  <h2>Store Details</h2>
			  <div id="storeInfo" class="accordion">
				  
				  <?php
					foreach($stores as $store){
				  ?>
					<div class="aStore accordion-group" id="store_<?php echo $store['store_id']; ?>">
					  <div class="offsetPadLeft accordion-heading">
						<h3 class="accordion-toggle" data-toggle="collapse" data-parent="#storeInfo" href="#store<?php echo $store['store_id']; ?>">
						  <?php echo $store['store_name']; ?>
						  <span class="editStore">
							<a href="editStore.php?id=<?php echo $store['store_id']; ?>"><i class="icon-edit"></i></a>
						  </span>
						</h3>
					  </div><!--end div.accordion-heading-->
					  <div id="store<?php echo $store['store_id']; ?>" class="accordion-body collapse offsetPadLeftx2">
						<div class="accordion-inner">
						  <p><b>Address:</b> <?php echo $store['store_address']; ?>, <?php echo $store['store_city']; ?> <?php echo $store['store_zip']; ?></p>
						  <p><b>Phone:</b> <?php echo preg_replace("/([0-9]{3})([0-9]{3})([0-9]{4})/", "($1) $2-$3", $store['store_phone']); ?></p>
						  <?php
							if($store['store_pharmPhone'] != ""){
						  ?>
						  <p><b>Pharmacy Phone:</b> <?php echo preg_replace("/([0-9]{3})([0-9]{3})([0-9]{4})/", "($1) $2-$3", $store['store_pharmPhone']); ?></p>
						  <?php
							}
						  ?>
						  <p><b>Fax:</b> <?php echo $store['store_fax']; ?></p>
						  <h5>Store Hours</h5>
						  <div class="offsetPadLeft">
							<p><b>Mon-Fri:</b> <?php echo $store['store_hMonOpen']; ?> - <?php echo $store['store_hMonClose']; ?></p>
							<p><b>Saturday:</b> <?php echo $store['store_hSatOpen']; ?> - <?php echo $store['store_hSatClose']; ?></p>
							<?php
							  if($store['store_hSunOpen'] != "Closed"){
							?>
							  <p><b>Sunday:</b> <?php echo $store['store_hSunOpen']; ?> - <?php echo $store['store_hSunClose']; ?></p>
							<?php
							  }else{
							?>
							  <p><b>Sunday:</b> <?php echo $store['store_hSunOpen']; ?></p>
							<?php
							  }
							?>
						  </div>
						  <?php
							if($store['store_hMonOpenPharm'] != ""){
						  ?>
							<h5>Pharmacy Hours</h5>
							<div class="offsetPadLeft">
							<?php
							  if($store['store_hMonOpenPharm'] == $store['store_hSatOpenPharm'] && $store['store_hMonClosePharm'] == $store['store_hSatClosePharm']){
							?>
							  <p><b>Mon-Sat:</b>
							  <span><?php echo $store['store_hMonOpenPharm']; ?> - <?php echo $store['store_hMonClosePharm']; ?></span></p>
							<?php
							  }else{
							?>
							  <p><b>Mon-Fri:</b>
							  <span><?php echo $store['store_hMonOpenPharm']; ?> - <?php echo $store['store_hMonClosePharm']; ?></span></p>
							  <p><b>Saturday:</b>
							  <span><?php echo $store['store_hSatOpenPharm']; ?> - <?php echo $store['store_hSatClosePharm']; ?></span></p>
							<?php
							  }
							  
							  if($store['store_hSunOpenPharm'] == "Closed"){
							?>
							  <p><b>Sunday:</b>
							  <span>Closed</span></p>
							<?php
							  }else{
							?>
							  <p><b>Sunday:</b>
							  <span><?php echo $store['store_hSunOpenPharm']; ?> - <?php echo $store['store_hSunClosePharm']; ?></span></p>
							<?php
							  }
							?>
							</div>
						  <?php
							}
						  ?>
						</div><!--end div.accordion-inner-->
					  </div><!--end div.accordion-body.collapse.offsetPadLeftx2-->
					</div><!--end div.aStore-->
				  <?php
					}
				  ?>
			  </div>
			</div>
		  </div>
	    </div>
	    
      </section>
      
    </section>
      
    

  <script>
   
    $(".accordion-heading a").on("click", function(e){
	  e.stopPropagation();
	});
	
	$(".accordion-heading h3").get(0).click();
  </script>
  

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
