<?php 
	require_once('inc/constants.inc.php');
	
	if(!isset($_SESSION)){
		session_start();
	}
	
	
	if(isset($_SESSION['LoggedIn']) && isset($_SESSION['Username']) && $_SESSION['LoggedIn'] === 1){
		//echo "<h1>YES, YOU ARE LOGGED IN</h1>";
		if(isset($_SESSION['returnURL'])){
			if($_SESSION['returnURL'] == "/admin/interactions.php"){
				header("Location: index.php");
				die;
			}else{
				header("Location: " . $_SESSION['returnURL']);
				die;
			}
			
		}else{
			header("Location: index.php");
			die;
		}
		
	}
	
	
	if(!empty($_POST['useremail']) && !empty($_POST['password'])){
		require_once("inc/class.users.inc.php");
		$users = new users();
		if($_POST['whichForm'] === "login"){
			$theResult = $users->accountLogin();
		}else if($_POST['whichForm'] === "facebook"){
			$theResult = $users->accountLoginFB();
		}
		
		if($theResult === true){
			if(isset($_SESSION['returnURL'])){
				header("Location: " . $_SESSION['returnURL']);
			}else{
				header("Location: index.php");
			}
		}else{ //If it couldn't register
			$theError = true;
		}
	}else if(isset($_POST['whichForm'])){
		$theError = true;
	}
	else{
		$theError = false;
	}
	
	$pageTitle = "Login";
	$pageKeywords = "Login page";
	$loggedIn = false;
	
	require_once($_SERVER['DOCUMENT_ROOT'] . '/common/constants.php');
	include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php"); 
	include_once($_SERVER['DOCUMENT_ROOT'] . "/common/mainNav.php");
	
?>


	<div id="fb-root"></div>
	<script>
		// Load the SDK Asynchronously
	  (function(d){
		 var js, id = 'facebook-jssdk', ref = d.getElementsByTagName('script')[0];
		 if (d.getElementById(id)) {return;}
		 js = d.createElement('script'); js.id = id; js.async = true;
		 js.src = "//connect.facebook.net/en_US/all.js";
		 ref.parentNode.insertBefore(js, ref);
	   }(document));
	</script>

	
	
    
    <section class="container">
		<div id="blankBuffer" class="carousel-buffer"></div>
		<section class="container" id="mainContent">
			<div class="loginBox clearfix">
				<div class="span5 offset3 clearfix">
					<div class="well">
						<legend>Sign in to Store Portal</legend>
						<?php if($theError): ?>
							<div class="alert alert-error">
								<a class="close" data-dismiss="alert" href="#">x</a>Incorrect Username or Password!
							</div>
						<?php endif;//end if($theError) ?>
						<form method="POST" action="login.php" name="loginform" id="loginform" class="cf" accept-charset="UTF-8">
							<input type="hidden" name="whichForm" id="whichForm" value="login"/>
							<input class="span4" placeholder="User Email" type="text" name="useremail" id="useremail"><br>
							<input class="span4" placeholder="Password" type="password" name="password" id="password" ><br>
							<button class="btn" type="submit">Login</button>
						</form>
					</div>
				</div>
				
				<div class="span5 offset3">
					<div class="well info">
						<p>Don't have an account? <a href="signup.php">Click here to sign up.</a></p>
					</div>
				</div>
			</div><br />
        </section>
    </section>


<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>
