<?php include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/sessionStartGeneral.php") ?>

<?php
  $pageTitle = "Recipe Home";
  $pageDescription = STORE_NAME . " has great recipe ideas for you and your whole family.";
  $pageKeywords = STORE_NAME . " recipes, " . STORE_NAME . " recipe ideas";
?>

<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php"); 
?>

<style>
	  #mainContent .row .span12{
			width: 95%;
	  }
	  
	  
	  
	  /*TAKE THESE TO BOOTSTRAP.LESS*/
	  
	  
	  
</style>
<script src="/Kickstrap/js/jquery-ui-1.9.0.custom.min.js"></script>
<link href="/Kickstrap/css/smoothness/jquery-ui-1.9.0.custom.css" rel="stylesheet">

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/mainNav.php'); ?>

<?php
	  $recipeID = 1;
	  
	  if(isset($_GET['id'])){
			$action = "showOne";
			$recipeID = $_GET['id'];
	  }else{
			$action = "showAll";
	  }
	  
	  
?>

    
    <section class="container">
      <div id="blankBuffer"></div>
      <section class="container" id="mainContent">
	    <div class="row">
		  <div class="span12">
				  <div id="recipeOffset">
					  <div id="headerContain" class="clearfix">
						  <?php
							  if($action == "showAll"){
						  ?>
							<h1 class="pull-left">Find your perfect recipe</h1>
						  
							<div id="searchContainer" class="pull-right">
							  <label for="autocomplete">Find a recipe: </label>
							  <input id="autocomplete">
							</div>
					  </div>
					  <p id="commentary" class="hidden-phone">Coming up with ideas for a meal is difficult, but we are trying to make it easier on you. <br>Use this database of great-tasting meals to make your meal planning a cinch.</p>
						  
						  <?php
						  }
						  ?>
						
						<!--<h1>Recipes</h1>-->
						<div id="recipeContainers">
						  <div id="leftCol" class="clearfix span6"></div>
						  <div id="rightCol" class="clearfix span6"></div>
						</div>
				  </div> 
			</div>
		  <!--</form>-->
	    </div>
	    
	    
      </section>
      
    </section>
      
    
    
    
    
    
    

  
  <script>
   var theAction = "<?php echo $action; ?>";
   
   var recipeNames = new Array();
   
   
   if(theAction == "showAll"){
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=getAllRecipes&groupBy=category",
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "allRecipeCallback"
	  });
   }else if(theAction == "showOne"){
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=getRecipe&id=<?php echo $recipeID; ?>",
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "oneRecipeCallback"
	  });
   }
   
	function allRecipeCallback(theResponse){
	  var theHTML = "";
	  var oldCat = "None";
	  var catRecipeNum = 0;
	  var contentHere = "";
	  
	  var windowWidth = $(window).width();
	  
	  $.each(theResponse, function(){
			recipeNames.push({"label": this.DishTitle, "value": this.ID});
			
			if(this.DishImage === null){
			  var theImage = "none.png";
			  var smallRecipeInfoClass = "noImage";
			}else{
			  var theImage = this.DishImage;
			  var smallRecipeInfoClass = "hideObject";
			}
			
			if(this.category != oldCat){
				  if(this.category != "None"){
						theHTML += "</div>"; //closing of categoryHolder div
				  }
				  catRecipeNum = 0;
				  //console.log("NEW CATEGORY");
				  if(windowWidth > 640){
					contentHere = fillContent("#recipeContainers");
				  }else{
					contentHere = "#leftCol";
				  }
				  
				  //console.log("left: " + $("#leftCol").height() + "\nright: " + $("#rightCol").height() + "\n" + this.category + ": " + contentHere);
				  $(contentHere).append(theHTML).addClass("test");
				  theHTML = "";
				  
				  theHTML += "<div id='" + this.category.replace(" ", "")+ "' class='categoryHolder clearfix'>";
				  theHTML += "<h2>" + this.category + "</h2>";
				  $(contentHere).removeClass("test");
			}
			
			if(catRecipeNum == 0){
				  theHTML += "<div class='featureRecipe'>";
				  theHTML += "<a href='recipes/" + this.DishTitle.replace(/\ /g, "-") + "'>";
				  theHTML += "<img width='205' height='200' src='https://afsshareportal.com//Kickstrap/img/recipes/" + theImage + "' alt='" + this.DishTitle + "'>";
				  theHTML += "</a>";
				  //theHTML += "<div class='theShadow'>";
				  //theHTML += "<img width='205' alt='Shadow' src='https://afsshareportal.com//Kickstrap/img/recipes/recipeShadow.png'>";
				  //theHTML += "</div>";
				  theHTML += "<div class='recipeInfo'>";
				  theHTML += "<h3>" + this.DishTitle + "</h3>";
				  theHTML += "<h5>" + this.category + "</h5>";
				  theHTML += "</div>";
				  theHTML += "</div>";
			}else{
				  if((catRecipeNum - 1) % 3 == 0){
						var marginClass = "noMargLeft";
				  }else{
						var marginClass = "";
				  }
				  
				  theHTML += "<a href='recipes/" + this.DishTitle.replace(/\ /g, "-") + "'>";
				  theHTML += "<div id='recipe_" + this.ID + "' class='clearfix aRecipe " + marginClass + "'>";
				  theHTML += "<img src='https://afsshareportal.com//Kickstrap/img/recipes/" + theImage + "' alt='" + this.DishTitle + "'>";
				  
				  theHTML += "<div class='smallRecipeInfo " + smallRecipeInfoClass + "'>";
				  theHTML += "<h3>" + this.DishTitle + "</h3>";
				  theHTML += "</div>";
				  theHTML += "</div>";
				  theHTML += "</a>";
			}
			
			oldCat = this.category;
			catRecipeNum++;
			
	  });
	  
	  theHTML += "</div>"; //closing of categoryHolder div
	  $(contentHere).append(theHTML).addClass("test");
	  //$("#recipeOffset").append(theHTML);
   }
   
   function oneRecipeCallback(theResponse){
	  var theHTML = "";
	  
	  if(theResponse == null){
		$.ajax({
			type: "POST",
			url: "/admin/lookUp.php",
			data: "action=getRecipe&recipeID=<?php echo $recipeID; ?>",
			dataType: "json",
			success: function(theResponse){
			  showRecipe(theResponse, "/Kickstrap/img");
			}
		});
	  }else{
		showRecipe(theResponse, "https://afsshareportal.com//Kickstrap/img/recipes");
	  }
	  
	  function showRecipe(theResponse, imgPath){
		$(document).attr("title", theResponse['DishTitle']);
		theHTML += "<div id='recipeContainer'>";
		theHTML += "<h2>" + theResponse['DishTitle'] + "</h2>";
		if(theResponse['DishImage'] !== null){
			  theHTML += "<div class='floatLeft'>";
			  theHTML += "<img class='theRecipe' src='" + imgPath + "/" + theResponse['DishImage'] + "' alt='" + theResponse['DishTitle'] + "'>";
			  //theHTML += "<div id='theShadow'>";
			  //theHTML += "<img src='https://afsshareportal.com//Kickstrap/img/recipes/recipeShadow.png' alt='Shadow for Picture' width='250'>";
			  //theHTML += "</div>";
			  theHTML += "</div>";
		}
		
		theHTML += "<div id='recipeTitleBlock' class='floatLeft'>";
		theHTML += "<h3>" + theResponse['category'] + "</h3>";
		theHTML += "<h4>Servings: <span class='muted'>" + theResponse['Serves'] + "</span></h4>";
		
		if(theResponse['PrepTime'] != "0 minutes"){
			  theHTML += "<h4>Prep Time: <span class='muted'>" + theResponse['PrepTime'] + "</span></h4>";
		}
		
		if(theResponse['CookTime'] != "0 minutes"){
			  theHTML += "<h4>Cook Time: <span class='muted'>" + theResponse['CookTime'] + "</span></h4>";
		}
		
		theHTML += "</div>";
		
		theHTML += "<div style='clear:both;'>";
		if(theResponse['description'] != "None"){
			  theHTML += "<h3 id='descriptionTitleHolder'>Description</h3>";
			  theHTML += "<p id='descriptionHolder'>" + theResponse['description'] + "</p>";
		}
		
		var ingredientArray = theResponse['ingredients'].split("|");
		theHTML += "<h3>Ingredients</h3>";
		$.each(ingredientArray, function(key, value){
			  theHTML += "<p class='offsetPadLeft'>" + value + "</p>";
		});
		
		
		if(theResponse['directions'] !== null){
		  var directionsArray = theResponse['directions'].split("|");
		  theHTML += "<h3>Directions</h3>";
		  
		  theHTML += "<ol class='offsetPadLeft'>";
		  $.each(directionsArray, function(key, value){
				theHTML += "<li>" + value + "</p>";	
		  });
		
		}
		
		theHTML += "</div>";
		theHTML += "</div>";
		
		theHTML += "<div id='produceContainer'></div>";
		
		$("#recipeOffset").append(theHTML);
		
		produceMainIng(theResponse['MainIng']);
	  }
   }
   
   function produceMainIng(produceItem){
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=getProduceItem&itemName=" + produceItem,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "produceItemCallback"
	  });
   }
   
   function produceItemCallback(response){
	  //console.log(response);
	  response = response[0];
	  var theHTML = "";
	  
	  theHTML += "<div id='theIngredient'>";
	  theHTML += "<img src='https://afsshareportal.com//Kickstrap/img/glossary/" + response['photo'] + "' width='100%' alt='" + response['name'] + "'>";
	  theHTML += "<h2>" + response['name'] + "</h2>";
	  theHTML += "<p>" + response['description'] + "</p>";
	  theHTML += "</div>";
	  
	  $("#produceContainer").append(theHTML);
	  
	  getMoreRecipes(response['searchTerm'], response['name']);
   }
   
   function getMoreRecipes(searchTerm, itemName){
	  $.ajax({
		type: "GET",
		url: base_site + "lookUpFeatures.php",
		data: "action=otherRecipes&search=" + searchTerm + "&item=" + itemName,
		dataType: "jsonp",
		jsonp : "callback",
		jsonpCallback: "moreRecipesCallback"
	  });
   }
   
   function moreRecipesCallback(recipes){
	  //console.log(recipes);
	  var theHTML = "";
	  theHTML += "<h4>More Recipes with " + recipes['search'] + "</h4>";
	  
	  //var theCount = 1;
	  theHTML += "<ol class='offsetPadLeft'>";
	  $.each(recipes, function(key, value){
			//console.log(this);
			if(key != "search"){
				  theHTML += "<li><a href='/recipes/" + value['DishTitle'].replace(/\ /g, "-") + "'>" + value['DishTitle'] + "</a></li>";
				  //theCount++;
			}
	  });
	  theHTML += "</ol>";
	  theHTML += "<br><br><h4>More Actions</h4>";
	  theHTML += "<div class='offsetPadLeft'>";
	  theHTML += "<a href='/recipes' class='btn btn-primary'>View all recipes</a><br><br>";
	  theHTML += "<a href='/produceGlossary.php' class='btn btn-primary'>View Produce Glossary</a>";
	  theHTML += "</div>";
	  
	  $("#produceContainer").append(theHTML);
   }
   
   
   
   ks.ready(function() {
      // JavaScript placed here will run only once Kickstrap has loaded successfully.
      
	  myAutocompleteRecipe(recipeNames);
	  
	  
	  
	  $(".aRecipe").hover(
		  function () {
			  //var theID = $(this).attr("id");
			  $("div.smallRecipeInfo", this).not(".noImage").removeClass("hideObject");
		  },
		  function () {
			  //var theID = $(this).attr("id");
			  $("div.smallRecipeInfo", this).not(".noImage").addClass("hideObject");
	   });
      /*$.pnotify({
         title: 'Hello World',
         text: 'To edit this message, find me at the bottom of this HTML file.'
      });*/
   });
  </script>
  
<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>