<?php include_once($_SERVER['DOCUMENT_ROOT'] . "/admin/inc/sessionStartGeneral.php") ?>
<?php
  $pageTitle = "Online Store Directory";
  $pageDescription = "Can't find what you are looking for at " . STORE_NAME . "? Let our online store directory find everything you are looking for.";
  $pageKeywords = "store directory, search";
?>
<?php
  include_once($_SERVER['DOCUMENT_ROOT'] . "/common/header.php"); 
?>

<style>
	  #mainContent .row .span12{
			width: 95%;
	  }
	  
	  
	  
	  /*TAKE THESE TO BOOTSTRAP.LESS*/
	  
	  .itemName{
		/*width:10%;*/
	  }
	  
	  .itemLocation{
		/*width: 5%;*/
	  }
	  
</style>

<script src="/Kickstrap/js/jquery-ui-1.9.0.custom.min.js"></script>
<link href="/Kickstrap/css/smoothness/jquery-ui-1.9.0.custom.css" rel="stylesheet">
  
<!--<link href="/css/storeDirectories.css" rel="stylesheet">-->

<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/mainNav.php'); ?>
<?php require($_SERVER['DOCUMENT_ROOT'] . '/admin/inc/class.features.inc.php'); ?>

<?php
  if(isset($_GET['store'])){
	$store = $_GET['store'];
  }else{
	$store = 1;
  }
  
  $storeObj = new stores();
  $allItems = $storeObj->getUsedDirectoryItems(str_replace("_", " ", $store));
  $allLocations = $storeObj->getStoreLocations();
  //echo "<pre>";
  //var_dump($allItems);
  //echo "</pre>";
  
  
  $itemNames = array();
  foreach($allItems['items'] as $anItem){
	
	array_push($itemNames, $anItem['item_name']);
  }
  
?>

    
    <section class="container">
      <div id="blankBuffer"></div>
      <section class="container" id="mainContent">
	    <div class="row">
		  <div class="span12">
			<div id="directoryOffset">
			  <h2 id="storeName1">Store Directory for <span id="locationSpan"><?php echo $allItems['storeInfo']['store_name']; ?></span></h2>
			  <h5 id="lastUpdated">Last updated: <span id="updateTime"> <?php echo date('F d, Y', strtotime($allItems['storeInfo']['store_update'])); ?></span></h5>
			  <?php
				if(count($allLocations) > 1){
			  ?>
			  <select>
				<option>View directory for other location: </option>
				<?php
				  foreach($allLocations as $aLocation){
				?>
				  <option class="changeDirectory"><?php echo $aLocation['store_name']; ?></option>
				<?php
				  }//end foreach($allLocations as $aLocation)
				?>
			  </select>
			  <?php
				}//end if(count($allLocations) > 1)
			  ?>
			  <?php
				if(count($itemNames) > 0){
			  ?>
				<div id="headerContain" class="clearfix">
				  <div id="searchContainer" class="pull-right">
					<label for="autocomplete">Find an item: </label>
					<input id="autocomplete">
				  </div>
				  <div id="alphaNav" class="cf">
					<div id="column3">
						<a href="#" id="searchAlpha" class="btn btn-primary">ABC Lookup</a>
						<!--
						<a href="#mainLogo" class="arctic_scroll" data-offset="-30" id="goToTop">Go to top of page</a>
						-->
					</div>
					<div id="alphaNavLinks" class="hideObject clearfix"></div>
					<script>
						//var myLetters = new Array;
						var myHTML = "";
						for(var myCount = 0; myCount < 26; myCount += 3){
							var startLetter = String.fromCharCode("A".charCodeAt(0) + myCount);
							var finishLetter = String.fromCharCode("A".charCodeAt(0) + (myCount +2));
							if(finishLetter == "["){
								finishLetter = "Z";	
							}
							myHTML += "<div class=\"letterNav\" id=\""+ startLetter +"nav\"><a href=\"#" + startLetter + "NavItem\" class=\"arctic_scroll\" data-offset=\"-315\">" + startLetter + " - " + finishLetter + "</a></div>";
						}
						
						$("#alphaNavLinks").append(myHTML);
						
					</script>
					
				  </div>
				  
				  <div id="listHead">
					<h4><span class='itemNameGen' id='itemNameSort'>Item Name <i id='nameSortIcon' class="icon-sort-down"></i></span><span class='lessMargin' id='aisleSort'>Aisle Number  <i id='aisleSortIcon' class="icon-sort-down"></i></span></h4>
				  </div>
				</div>
				<div id="display" class="hideObject">
				  <table id="theResults" width="100%"></table>
				  <br><br>
				  <p>
					<a href="#" id="showAllItems">Show All Items</a>
				  </p>
				</div>
				
				<div id="storeHide">
				  <table id="storeInfo">
					  <!--
					  <thead>
						<tr>
						  <td class="tablePaddingFirstTD">Item Name</td>
						  <td>Aisle Number</td>
						</tr>
					  </thead>
					  -->
					  <?php
						$oldFirstLetter = "Z";
						foreach($allItems['items'] as $anItem){
						  $navID = "";
						  $firstLetter = substr($anItem['item_name'], 0, 1);
						  if($firstLetter != $oldFirstLetter){
							  $navID = $firstLetter . "NavItem";
						  }
					  ?>
						<tr id="<?php echo $navID; ?>">
						  <td class="sortName itemName"><?php echo $anItem['item_name']; ?></td>
						  <td class="itemLocation sortAisle"><?php echo str_replace("_", " ", $anItem['aisle']); ?></td>
						</tr>
					  <?php $oldFirstLetter = $firstLetter;
						}
					  ?>
				  </table>
				</div>
			  <?php
				}//end if(count($itemNames) > 0)
				else{
				  
			  ?>
				<p>We currently do not have aisle information for this store.</p>
			  <?php
				}
			  ?>
			  
			</div> 
		  </div>
		  <!--</form>-->
	    </div>
	    
	    
      </section>
      
    </section>
      
    
    
    
    
    
    

  
  <script type="text/javascript">
	  $(document).ready(function(e) {
		  myAutocompleteDirectory();
		  
		  $("#showStoreList").bind("click", function(e){
			  e.preventDefault();
			  var theWords = $(this).html() == "Switch store" ? "Hide store list" : "Switch store";
			  $("#noStore").toggleClass("hideObject");
			  $(this).html(theWords);
		  });
		  var myGetVars = getUrlVars();
		  
		  
		  $("#showAllItems").bind("click", function(e){
			  e.preventDefault();
			  $("#autocomplete").val("");
			  $("#storeHide").removeClass('hideObject');
			  $("#display").addClass('hideObject');
		  });
		  //console.log(myGetVars['store'] != null);
		  
		  /*
		  if(myGetVars['store'] != null){
			  $("#noStore").addClass("hideObject");
			  $("#storeInfo").removeClass("hideObject");	
		  }else{
			  $("#noStore").removeClass("hideObject");
			  $("#storeInfo").addClass("hideObject");
		  }
		  */
		  
		  $("#storeInfo tbody tr:nth-child(2n-1)").addClass("grayBG");
		  
		  $("#searchAlpha").bind("click", function(e){
			  e.preventDefault();
			  $("#alphaNavLinks").toggleClass("hideObject");
			  if($(this).html() == "ABC Lookup")
				  $(this).html("Hide ABC Lookup");
			  else	
				  $(this).html("ABC Lookup");
		  });
		  
		  $("#alphaNav .letterNav a").bind("click", function(e){
			  $("#alphaNavLinks").addClass("hideObject");
			  $("#searchAlpha").html("ABC Lookup");
		  });
		  
		  $("#locationSelect").bind("change", function(){
			  var storeID = $(this).val();
			  $(function () {
				  $.ajax({
					  type: "GET",
					  url: 'storeAisles.php?storeID=' + storeID,
					  dataType: "json",
					  success: function (data) {
						  var numReturned = data.length;
						  $("span.itemLocation").html(""); //reset the form
						  if(numReturned > 0){
							  $.each(data, function () {
								  var itemID = this.item_id;
								  var aisleNum = this.aisle;
  
								  $("#" + itemID).html(aisleNum);
								  
								  if(this.update){
									  
									  $("#updateTime").html(this.update);	
								  }
							  });
							  $("#storeInfo").removeClass("hideObject");
						  }
					  }
				  });
			  })
		  });
		  
		  var compare_rows_aisle = function (a,b){
			if(a.cells[1].innerHTML.length == 1){
				var newA = "0" + a.cells[1].innerHTML;
			}else{
				var newA = a.cells[1].innerHTML;
			}
			
			if(b.cells[1].innerHTML.length == 1){
				var newB = "0" + b.cells[1].innerHTML;
			}else{
				var newB = b.cells[1].innerHTML;
			}
			
			
			if (newA < newB) {
				return -1;
			} else if (newA > newB) {
				return 1;
			}
			return 0;
		  };
		  
		  var compare_rows_name = function (a,b){
			if (a.cells[0].innerHTML < b.cells[0].innerHTML) {
				return -1;
			} else if (a.cells[0].innerHTML > b.cells[0].innerHTML) {
				return 1;
			}
			return 0;
		  };
		  
		  $('#aisleSort, #itemNameSort').click(function(ev){
			// a simple compare function, used by the sort below
			var theImage = $("i", this).attr("class");
			//var fileName = theImage.split('/')[1].split('.')[0];
			
			if(theImage == "icon-sort-up"){
				reverseSort = true;
			}else if(theImage == "icon-sort-down"){
				reverseSort = false;
			}
			
			
			
			if($(this).attr("id") == "aisleSort"){
			  var theClass = ".sortAisle";  
			  var sorted = $('#storeInfo tbody tr').sort(compare_rows_aisle);
			  //var reversed = sorted.reverse(); 
			  if(reverseSort == true){
				  $("#storeInfo").append(sorted.get().reverse());
				  $("i", this).removeClass("icon-sort-up").addClass("icon-sort-down");
			  }else{
				  $("#storeInfo").append(sorted);
				  $("i", this).removeClass("icon-sort-down").addClass("icon-sort-up");
			  }
			  $("#itemNameSort img").attr("src", "images/uup.png");
			}else if ($(this).attr("id") == "itemNameSort"){
			  //console.log(fileName + " - " + reverseSort);
			  var theClass = ".sortName"; 
			  var sorted = $('#storeInfo tbody tr').sort(compare_rows_name);
			  //var reversed = sorted.reverse(); 
			  if(reverseSort == true){
				  $("#storeInfo").append(sorted.get().reverse());
				  $("i", this).removeClass("icon-sort-up").addClass("icon-sort-down");
			  }else{
				  $("#storeInfo").append(sorted);
				  $("i", this).removeClass("icon-sort-down").addClass("icon-sort-up");
			  }
			  $("#aisleSort i").removeClass("icon-sort-down").addClass("icon-sort-up");
			}
			
			$("html, body").animate({ scrollTop: 0 }, 600);
			
			//get zebra stripes
			$("#storeInfo tr").removeClass("grayBG");
			$("#storeInfo tr:nth-child(2n-1)").addClass("grayBG");
		 
		  });
		  
		  $(".changeDirectory").bind("click", function(){
			var theLoc = $(this).html().toLowerCase();
			window.location = docRoot + "directory/" + theLoc.replace(" ", "_");
		  });
	  });
	  
	  
	  
	  
  </script>
  
  <script>
   
   ks.ready(function() {
      // JavaScript placed here will run only once Kickstrap has loaded successfully.
   });
  </script>
  
<?php require($_SERVER['DOCUMENT_ROOT'] . '/common/footer.php'); ?>